/*
 * Decompiled with CFR 0.152.
 */
package manage.mongo;

import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.mongodb.springdata.v4.SpringDataMongoV4Driver;
import io.mongock.runner.springboot.MongockSpringboot;
import io.mongock.runner.springboot.RunnerSpringbootBuilder;
import io.mongock.runner.springboot.base.MongockApplicationRunner;
import java.util.Arrays;
import manage.conf.MetaDataAutoConfiguration;
import manage.mongo.EpochConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;

@Configuration
public class MongoConfiguration {
    @Bean
    public MongoCustomConversions customConversions() {
        return new MongoCustomConversions(Arrays.asList(new EpochConverter()));
    }

    @Bean
    public MongockApplicationRunner mongockApplicationRunner(ApplicationContext springContext, MetaDataAutoConfiguration metaDataAutoConfiguration, MongoTemplate mongoTemplate) {
        SpringDataMongoV4Driver driver = SpringDataMongoV4Driver.withDefaultLock((MongoTemplate)mongoTemplate);
        driver.disableTransaction();
        return ((RunnerSpringbootBuilder)((RunnerSpringbootBuilder)((RunnerSpringbootBuilder)((RunnerSpringbootBuilder)MongockSpringboot.builder().setDriver((ConnectionDriver)driver)).addMigrationScanPackage("manage.mongo")).addDependency((Object)metaDataAutoConfiguration)).setSpringContext(springContext)).buildApplicationRunner();
    }

    @Bean
    public MongoTransactionManager transactionManager(MongoTemplate mongoTemplate) {
        return new MongoTransactionManager(mongoTemplate.getMongoDatabaseFactory());
    }
}

