/*
 * Decompiled with CFR 0.152.
 */
package manage.mongo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
public class MongoConverter {
    private final MappingMongoConverter mongoConverter;
    private final MongoTemplate mongoTemplate;

    @Autowired
    public MongoConverter(MappingMongoConverter mongoConverter, MongoTemplate mongoTemplate) {
        this.mongoConverter = mongoConverter;
        this.mongoTemplate = mongoTemplate;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void initIndicesAfterStartup() {
        this.mongoConverter.setMapKeyDotReplacement("@");
        MongoMappingContext mappingContext = (MongoMappingContext)this.mongoConverter.getMappingContext();
        MongoPersistentEntityIndexResolver resolver = new MongoPersistentEntityIndexResolver((MappingContext)mappingContext);
        mappingContext.getPersistentEntities().forEach(persistentEntity -> {
            Class clazz = persistentEntity.getType();
            if (clazz.isAnnotationPresent(Document.class)) {
                IndexOperations indexOps = this.mongoTemplate.indexOps(clazz);
                resolver.resolveIndexFor(clazz).forEach(arg_0 -> ((IndexOperations)indexOps).createIndex(arg_0));
            }
        });
    }
}

