/*
 * Decompiled with CFR 0.152.
 */
package myconext.captcha;

import java.util.Map;
import myconext.captcha.ApiHeaderInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class CaptchaVerifier {
    private static final Log LOG = LogFactory.getLog(CaptchaVerifier.class);
    private final boolean captchaEnabled;
    private final String captchaHost;
    private final String captchaSiteKey;
    private final RestTemplate restTemplate;

    public CaptchaVerifier(@Value(value="${feature.captcha_enabled}") boolean captchaEnabled, @Value(value="${captcha.host}") String captchaHost, @Value(value="${captcha.sitekey}") String captchaSiteKey, @Value(value="${captcha.apikey}") String captchaApiKey) {
        this.captchaEnabled = captchaEnabled;
        this.captchaHost = captchaHost;
        this.captchaSiteKey = captchaSiteKey;
        this.restTemplate = new RestTemplate();
        this.restTemplate.getInterceptors().add(new ApiHeaderInterceptor(captchaApiKey));
    }

    public boolean verify(String captchaResponse) {
        if (!this.captchaEnabled) {
            return true;
        }
        Map<String, String> request = Map.of("response", captchaResponse, "sitekey", this.captchaSiteKey);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.captchaHost, request, Map.class, new Object[0]);
        Map body = (Map)responseEntity.getBody();
        boolean success = body.getOrDefault("success", false);
        if (!success) {
            LOG.warn((Object)("Unsuccessful response from captcha: " + String.valueOf(body)));
        }
        return success;
    }
}

