/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import com.mongodb.client.MongoClient;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import myconext.cron.AbstractNodeLeader;
import myconext.repository.AuthenticationRepository;
import myconext.repository.EnrollmentRepository;
import myconext.repository.RegistrationRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import tiqr.org.model.Authentication;
import tiqr.org.model.Enrollment;
import tiqr.org.model.Registration;
import tiqr.org.model.RegistrationStatus;

@Component
public class TiqrCleaner
extends AbstractNodeLeader {
    public static final String LOCK_NAME = "tiqr_cleaner_usage_lock_name";
    private static final Log LOG = LogFactory.getLog(TiqrCleaner.class);
    private final RegistrationRepository registrationRepository;
    private final AuthenticationRepository authenticationRepository;
    private final EnrollmentRepository enrollmentRepository;

    @Autowired
    public TiqrCleaner(RegistrationRepository registrationRepository, AuthenticationRepository authenticationRepository, EnrollmentRepository enrollmentRepository, MongoClient mongoClient, @Value(value="${mongodb_db}") String databaseName) {
        super(LOCK_NAME, mongoClient, databaseName);
        this.registrationRepository = registrationRepository;
        this.authenticationRepository = authenticationRepository;
        this.enrollmentRepository = enrollmentRepository;
    }

    @Scheduled(cron="${cron.token-cleaner-expression}")
    public void clean() {
        super.perform("TiqrCleaner#clean", () -> this.doClean());
    }

    private void doClean() {
        Instant hourAgo = Instant.now().minus(1L, ChronoUnit.HOURS);
        this.info(Authentication.class, this.authenticationRepository.deleteByUpdatedBefore(hourAgo).longValue());
        this.info(Registration.class, this.registrationRepository.deleteByUpdatedBeforeAndStatus(hourAgo, RegistrationStatus.INITIALIZED).longValue());
        this.info(Enrollment.class, this.enrollmentRepository.deleteByUpdatedBefore(hourAgo).longValue());
    }

    private void info(Class clazz, long count) {
        LOG.info((Object)String.format("Deleted Tiqr %s instances of %s in cleanup", count, clazz));
    }
}

