/*
 * Decompiled with CFR 0.152.
 */
package myconext.remotecreation;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import myconext.api.HasUserRepository;
import myconext.exceptions.DuplicateUserEmailException;
import myconext.exceptions.IdentityProviderNotFoundException;
import myconext.exceptions.UserNotFoundException;
import myconext.mail.MailBox;
import myconext.manage.Manage;
import myconext.model.EduID;
import myconext.model.EmailExistsResponse;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdentityProvider;
import myconext.model.IdpScoping;
import myconext.model.RemoteProvider;
import myconext.model.StatusResponse;
import myconext.model.User;
import myconext.model.Verification;
import myconext.remotecreation.EduIDAssignedValue;
import myconext.remotecreation.EduIDInstitutionPseudonym;
import myconext.remotecreation.EduIDValue;
import myconext.remotecreation.NewExternalEduID;
import myconext.remotecreation.UpdateExternalEduID;
import myconext.repository.UserRepository;
import myconext.security.RemoteUser;
import myconext.verify.AttributeMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(value={"feature.remote_creation_api"})
@RequestMapping(value={"/api/remote-creation"}, produces={"application/json"})
@SecurityRequirement(name="basic")
public class RemoteCreationController
implements HasUserRepository {
    private static final Log LOG = LogFactory.getLog(RemoteCreationController.class);
    private final UserRepository userRepository;
    private final Manage manage;
    private final MailBox mailBox;
    private final AttributeMapper attributeMapper;
    private final String schacHomeOrganization;

    public RemoteCreationController(UserRepository userRepository, Manage manage, MailBox mailBox, AttributeMapper attributeMapper, @Value(value="${schac_home_organization}") String schacHomeOrganization) {
        this.userRepository = userRepository;
        this.manage = manage;
        this.mailBox = mailBox;
        this.attributeMapper = attributeMapper;
        this.schacHomeOrganization = schacHomeOrganization;
    }

    @GetMapping(value={"/email-eduid-exists"})
    @PreAuthorize(value="hasRole('ROLE_remote-creation')")
    @Operation(summary="Does an eduID exists", description="Does an eduID exists with the email", responses={@ApiResponse(responseCode="200", description="Found", content={@Content(schema=@Schema(implementation=EmailExistsResponse.class), examples={@ExampleObject(value="{\"status\":200,\"eduIDValue\":\"8048ADA1-8C30-4CDA-8C88-36B865CD16FA\" }\n")})}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":400}")})}), @ApiResponse(responseCode="404", description="User not found by email unknown@example.com", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n \"timestamp\": 1717671062532,\n \"status\": 404,\n \"error\": \"Not Found\",\n \"exception\": \"myconext.exceptions.UserNotFoundException\",\n \"message\": \"User not found by email unknown@example.com\",\n \"path\": \"/api/remote-creation/email-eduid-exists\"\n}\n")})})})
    public ResponseEntity<EmailExistsResponse> emailEduIDExists(@Parameter(hidden=true) @AuthenticationPrincipal(errorOnInvalidType=true) RemoteUser remoteUser, @RequestParam(value="email") String email) {
        LOG.info((Object)String.format("GET email-eduid-exists by %s for %s", remoteUser.getUsername(), email));
        String remoteUserName = remoteUser.getUsername();
        User user = (User)this.userRepository.findUserByEmail(email).orElseThrow(() -> new UserNotFoundException(String.format("User not found by email %s", email)));
        RemoteProvider remoteProvider = this.getRemoteProvider(remoteUser, remoteUserName);
        String eduIDValue = user.computeEduIdForIdentityProviderProviderIfAbsent(remoteProvider, this.manage);
        this.userRepository.save((Object)user);
        return ResponseEntity.ok((Object)new EmailExistsResponse(HttpStatus.OK.value(), eduIDValue));
    }

    @GetMapping(value={"/eduid-exists"})
    @PreAuthorize(value="hasRole('ROLE_remote-creation')")
    @Operation(summary="Does an eduID exists", description="Does an eduID account exists with the eduID identifier", responses={@ApiResponse(responseCode="200", description="Found", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":200}")})}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":400}")})}), @ApiResponse(responseCode="404", description="Not found - eduID not found", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717671189426,\n  \"status\": 404,\n  \"error\": \"Not Found\",\n  \"exception\": \"myconext.exceptions.UserNotFoundException\",\n  \"message\": \"User not found by eduID 12345\",\n  \"path\": \"/api/remote-creation/eduid-exists\"\n}")})})})
    public ResponseEntity<StatusResponse> remoteCreation(@Parameter(hidden=true) @AuthenticationPrincipal(errorOnInvalidType=true) RemoteUser remoteUser, @RequestParam(value="eduID") String eduID) {
        LOG.info((Object)String.format("GET eduid-exists by %s for %s", remoteUser.getUsername(), eduID));
        this.findUserByEduIDValue(eduID).orElseThrow(() -> new UserNotFoundException(String.format("User not found by eduID %s", eduID)));
        return ResponseEntity.ok((Object)new StatusResponse(HttpStatus.OK.value()));
    }

    @PostMapping(value={"/eduid-institution-pseudonym"})
    @PreAuthorize(value="hasRole('ROLE_remote-creation')")
    @Operation(summary="Return a eduID pseudonym for an institution", description="Return a eduID pseudonym for an institution identified by the BRIN code", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EduIDValue.class), examples={@ExampleObject(value="{\n  \"value\": \"46ab5162-e098-4c24-9f28-cdf4d9b5fbb0\"\n}")})}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1718865813679,\n  \"status\": 400,\n  \"error\": \"Bad Request\",\n  \"exception\": \"org.springframework.web.bind.MethodArgumentNotValidException\",\n  \"message\": \"Validation failed for object='eduIDInstitutionPseudonym'. Error count: 1\",\n  \"path\": \"/api/remote-creation/eduid-institution-pseudonym\"\n}")})}), @ApiResponse(responseCode="404", description="Not found - eduID or BRIN code not found", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717671525908,\n  \"status\": 404,\n  \"error\": \"Not Found\",\n  \"exception\": \"myconext.exceptions.UserNotFoundException\",\n  \"message\": \"IdentityProvider with BRIN code AB!@ not found\",\n  \"path\": \"/api/remote-creation/eduid-institution-pseudonym\"\n}")})})})
    public ResponseEntity<EduIDValue> eduIDForInstitution(@Parameter(hidden=true) @AuthenticationPrincipal(errorOnInvalidType=true) RemoteUser remoteUser, @RequestBody @Validated EduIDInstitutionPseudonym eduIDInstitutionPseudonym) {
        LOG.info((Object)String.format("eduid-institution-pseudonym by %s for %s", remoteUser.getUsername(), eduIDInstitutionPseudonym));
        User user = (User)this.findUserByEduIDValue(eduIDInstitutionPseudonym.getEduID()).orElseThrow(() -> new UserNotFoundException(String.format("User with eduID %s not found", eduIDInstitutionPseudonym.getEduID())));
        IdentityProvider identityProvider = (IdentityProvider)this.manage.findIdentityProviderByBrinCode(eduIDInstitutionPseudonym.getBrinCode()).stream().findFirst().orElseThrow(() -> new IdentityProviderNotFoundException(String.format("IdentityProvider with BRIN code %s not found", eduIDInstitutionPseudonym.getBrinCode())));
        String eduIDValue = user.computeEduIdForIdentityProviderProviderIfAbsent((RemoteProvider)identityProvider, this.manage);
        this.userRepository.save((Object)user);
        return ResponseEntity.ok((Object)new EduIDValue(eduIDValue));
    }

    @PostMapping(value={"/eduid-institution-pseudonym-batch"})
    @PreAuthorize(value="hasRole('ROLE_remote-creation')")
    @Operation(summary="Return eduID pseudonyms for an institution", description="Return eduID pseudonyms for an institution identified by the BRIN code", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EduIDAssignedValue.class)), examples={@ExampleObject(name="Success", value="[{\n  \"eduID\": \"46ab5162-e098-4c24-9f28-cdf4d9b5fbb0\",\n  \"brinCode\": \"UV-001\",\n  \"value\": \"46ab5162-e098-4c24-9f28-cdf4d9b5fbb0\",\n  \"error\": null\n}]"), @ExampleObject(name="Unknown eduID", value="[{\n  \"eduID\": \"46ab5162-e098-4c24-9f28-cdf4d9b5fbb0\",\n  \"brinCode\": \"UV-001\",\n  \"value\": null,\n  \"error\": \"Unknown eduID\"\n}]"), @ExampleObject(name="Unknown brinCode", value="[{\n  \"eduID\": \"46ab5162-e098-4c24-9f28-cdf4d9b5fbb0\",\n  \"brinCode\": \"UV-001\",\n  \"value\": null,\n  \"error\": \"Unknown brinCode\"\n}]")})}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(name="BadRequest", value="{\n  \"timestamp\": 1718865813679,\n  \"status\": 400,\n  \"error\": \"Bad Request\",\n  \"exception\": \"org.springframework.web.bind.MethodArgumentNotValidException\",\n  \"message\": \"Validation failed for object='eduIDInstitutionPseudonym'. Error count: 1\",\n  \"path\": \"/api/remote-creation/eduid-institution-pseudonym-batch\"\n}")})})})
    public ResponseEntity<List<EduIDAssignedValue>> eduIDForInstitutionBatch(@Parameter(hidden=true) @AuthenticationPrincipal(errorOnInvalidType=true) RemoteUser remoteUser, @RequestBody @Validated List<EduIDInstitutionPseudonym> eduIDInstitutionPseudonyms) {
        LOG.info((Object)String.format("eduid-institution-pseudonym by %s for %s", remoteUser.getUsername(), eduIDInstitutionPseudonyms));
        Map<String, List<IdentityProvider>> identityProvidersGroupedBy = eduIDInstitutionPseudonyms.stream().map(pseudonym -> pseudonym.getBrinCode()).distinct().map(brinCode -> this.manage.findIdentityProviderByBrinCode(brinCode)).flatMap(Collection::stream).collect(Collectors.groupingBy(IdentityProvider::getInstitutionBrin));
        List eduIDAssignedValues = eduIDInstitutionPseudonyms.stream().flatMap(eduIDInstitutionPseudonym -> {
            String eduID = eduIDInstitutionPseudonym.getEduID();
            String brinCode = eduIDInstitutionPseudonym.getBrinCode();
            if (!identityProvidersGroupedBy.containsKey(brinCode)) {
                return Stream.of(new EduIDAssignedValue(eduID, null, brinCode, "Unknown brinCode"));
            }
            Optional optionalUser = this.findUserByEduIDValue(eduID);
            if (optionalUser.isEmpty()) {
                return Stream.of(new EduIDAssignedValue(eduID, null, brinCode, "Unknown eduID"));
            }
            List pseudonyms = optionalUser.map(user -> {
                List identityProviders = (List)identityProvidersGroupedBy.get(brinCode);
                List<String> eduIDValues = identityProviders.stream().map(identityProvider -> user.computeEduIdForIdentityProviderProviderIfAbsent((RemoteProvider)identityProvider, this.manage)).distinct().toList();
                this.userRepository.save(user);
                return eduIDValues;
            }).orElse(Collections.emptyList());
            return pseudonyms.stream().map(pseudonym -> new EduIDAssignedValue(eduID, pseudonym, brinCode, null));
        }).toList();
        return ResponseEntity.ok(eduIDAssignedValues);
    }

    @PostMapping(value={"/eduid-create"})
    @PreAuthorize(value="hasRole('ROLE_remote-creation')")
    @Operation(summary="Create an eduID", description="Create an eduID", responses={@ApiResponse(responseCode="201", description="Created", content={@Content(schema=@Schema(implementation=UpdateExternalEduID.class))}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":400}")})}), @ApiResponse(responseCode="409", description="Conflict - email already exists", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 409,\n  \"error\": \"Conflict\",\n  \"exception\": \"myconext.exceptions.DuplicateUserEmailException\",\n  \"message\": \"Email already in use\",\n  \"path\": \"/api/remote-creation/eduid-create\"\n}")})})})
    public ResponseEntity<UpdateExternalEduID> createEduID(@Parameter(hidden=true) @AuthenticationPrincipal(errorOnInvalidType=true) RemoteUser remoteUser, @RequestBody @Validated NewExternalEduID externalEduID) {
        String email = externalEduID.getEmail();
        String apiUserName = remoteUser.getUsername();
        LOG.info((Object)String.format("POST eduid-create by %s for %s", apiUserName, email));
        externalEduID.validate();
        this.userRepository.findUserByEmail(email).ifPresent(u -> {
            throw new DuplicateUserEmailException("There already exists a user with email " + email);
        });
        RemoteProvider remoteProvider = this.getRemoteProvider(remoteUser, apiUserName);
        String lastNamePrefix = externalEduID.getLastNamePrefix();
        String lastName = StringUtils.hasText((String)lastNamePrefix) ? String.format("%s %s", lastNamePrefix, externalEduID.getLastName()) : externalEduID.getLastName();
        User user = new User(UUID.randomUUID().toString(), externalEduID.getEmail(), externalEduID.getChosenName(), externalEduID.getFirstName(), lastName, this.schacHomeOrganization, LocaleContextHolder.getLocale().getLanguage(), remoteProvider, this.manage);
        user.setNewUser(false);
        String eduIDValue = ((EduID)user.getEduIDS().get(0)).getValue();
        UpdateExternalEduID updateExternalEduID = new UpdateExternalEduID(externalEduID, eduIDValue);
        ExternalLinkedAccount externalLinkedAccount = this.attributeMapper.createExternalLinkedAccount(externalEduID, IdpScoping.valueOf((String)apiUserName));
        user.getExternalLinkedAccounts().add(externalLinkedAccount);
        this.userRepository.save((Object)user);
        this.mailBox.sendAccountConfirmation(user);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)updateExternalEduID);
    }

    @PutMapping(value={"/eduid-update"})
    @PreAuthorize(value="hasRole('ROLE_remote-creation')")
    @Operation(summary="Update an eduID", description="Update an eduID", responses={@ApiResponse(responseCode="201", description="Created", content={@Content(schema=@Schema(implementation=UpdateExternalEduID.class))}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":400}")})}), @ApiResponse(responseCode="404", description="User not found", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672653898,\n  \"status\": 404,\n  \"error\": \"Not Found\",\n  \"exception\": \"myconext.exceptions.UserNotFoundException\",\n  \"message\": \"User not found by eduID 12345\",\n  \"path\": \"/api/remote-creation/eduid-update\"\n}")})})})
    public ResponseEntity<UpdateExternalEduID> updateEduID(@Parameter(hidden=true) @AuthenticationPrincipal(errorOnInvalidType=true) RemoteUser remoteUser, @RequestBody @Validated UpdateExternalEduID externalEduID) {
        String remoteUserName = remoteUser.getUsername();
        String email = externalEduID.getEmail();
        String eduIDValue = externalEduID.getEduIDValue();
        LOG.info((Object)String.format("PUT eduid-update by %s for %s or %s", remoteUserName, email, eduIDValue));
        User user = (User)this.findUserByEduIDValue(eduIDValue).orElseThrow(() -> new UserNotFoundException(String.format("User not found by eduID %s", eduIDValue)));
        user.updateWithExternalEduID((NewExternalEduID)externalEduID);
        AtomicBoolean userIsValidated = new AtomicBoolean(false);
        Optional<ExternalLinkedAccount> optionalExternalLinkedAccount = user.getExternalLinkedAccounts().stream().filter(account -> IdpScoping.valueOf((String)remoteUserName).equals((Object)account.getIdpScoping())).findAny();
        optionalExternalLinkedAccount.ifPresentOrElse(externalLinkedAccount -> {
            if (Verification.Ongeverifieerd.equals((Object)externalLinkedAccount.getVerification()) && !Verification.Ongeverifieerd.equals((Object)externalEduID.getVerification())) {
                userIsValidated.set(true);
            }
            externalLinkedAccount.updateAttributesFromUpdateExternalEduID(externalEduID, this.attributeMapper);
        }, () -> {
            RemoteProvider remoteProvider = this.getRemoteProvider(remoteUser, remoteUserName);
            String provisionedEduIDValue = user.computeEduIdForIdentityProviderProviderIfAbsent(remoteProvider, this.manage);
            externalEduID.setEduIDValue(provisionedEduIDValue);
            ExternalLinkedAccount externalLinkedAccount = this.attributeMapper.createExternalLinkedAccount((NewExternalEduID)externalEduID, IdpScoping.valueOf((String)remoteUserName));
            externalLinkedAccount.setAffiliations(this.attributeMapper.externalAffiliations(externalEduID.getBrinCodes()));
            if (!Verification.Ongeverifieerd.equals((Object)externalLinkedAccount.getVerification())) {
                userIsValidated.set(true);
            }
            user.getExternalLinkedAccounts().add(externalLinkedAccount);
        });
        this.userRepository.save((Object)user);
        if (userIsValidated.get()) {
            this.mailBox.sendUserValidated(user, externalEduID, remoteUserName);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)externalEduID);
    }

    @DeleteMapping(value={"/eduid-delete/{eduid}"})
    @PreAuthorize(value="hasRole('ROLE_remote-creation')")
    @Operation(summary="Delete the eduID pseudonym for the remote source", description="Delete the eduID pseudonym for the remote source", responses={@ApiResponse(responseCode="204", description="No content", content={@Content(schema=@Schema(implementation=Void.class))}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":400}")})}), @ApiResponse(responseCode="404", description="No eduID found", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 404,\n  \"error\": \"Not found\",\n  \"exception\": \"myconext.exceptions.UserNotFoundException\",\n  \"message\": \"User not found\",\n  \"path\": \"/api/remote-creation/eduid-delete\"\n}")})})})
    public ResponseEntity<Void> deleteEduID(@Parameter(hidden=true) @AuthenticationPrincipal(errorOnInvalidType=true) RemoteUser remoteUser, @PathVariable(value="eduid") String eduIDValue) {
        LOG.info((Object)String.format("DELETE eduid-delete by %s for %s", remoteUser.getUsername(), eduIDValue));
        User user = (User)this.userRepository.findByEduIDS_value(eduIDValue).orElseThrow(() -> new UserNotFoundException("User not found"));
        user.getEduIDS().removeIf(eduID -> eduID.getValue().equals(eduIDValue));
        this.userRepository.save((Object)user);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    private RemoteProvider getRemoteProvider(RemoteUser remoteUser, String remoteUserName) {
        return new RemoteProvider(null, remoteUserName, remoteUserName, remoteUser.getInstitutionGUID(), String.format("https://static.surfconext.nl/logos/org/%s.png", remoteUser.getInstitutionGUID()));
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

