/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import java.util.List;
import java.util.Map;
import myconext.exceptions.UserNotFoundException;
import myconext.model.User;
import myconext.repository.UserRepository;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;

public interface UserAuthentication {
    public UserRepository getUserRepository();

    default public User userFromAuthentication(Authentication authentication) {
        User user;
        boolean mobileAuthentication = authentication instanceof BearerTokenAuthentication;
        if (mobileAuthentication) {
            Map tokenAttributes = ((BearerTokenAuthentication)authentication).getTokenAttributes();
            String uid = (String)((List)tokenAttributes.get("uids")).getFirst();
            user = (User)this.getUserRepository().findUserByUid(uid).orElseThrow(() -> new UserNotFoundException(uid));
        } else {
            String userId = ((User)authentication.getPrincipal()).getId();
            user = (User)this.getUserRepository().findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        }
        user.setMobileAuthentication(mobileAuthentication);
        return user;
    }

    default public boolean isMobileRequest(Authentication authentication) {
        return authentication instanceof BearerTokenAuthentication;
    }
}

