/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import myconext.exceptions.WeakPasswordException;
import myconext.manage.Manage;
import myconext.model.ControlCode;
import myconext.model.CreateInstitutionEduID;
import myconext.model.EduID;
import myconext.model.ExternalLinkedAccount;
import myconext.model.LinkedAccount;
import myconext.model.LoginOptions;
import myconext.model.OneTimeLoginCode;
import myconext.model.ProvisionedLinkedAccount;
import myconext.model.PublicKeyCredentials;
import myconext.model.RemoteProvider;
import myconext.model.ServiceProvider;
import myconext.model.User;
import myconext.model.UserInactivity;
import myconext.remotecreation.NewExternalEduID;
import myconext.security.ServicesConfiguration;
import myconext.validation.PasswordStrength;
import myconext.verify.AttributeMapper;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Document(collection="users")
public class User
implements Serializable,
UserDetails {
    private static final List<SimpleGrantedAuthority> GUEST_AUTHORITIES = List.of(new SimpleGrantedAuthority("ROLE_GUEST"));
    @Id
    private String id;
    private String email;
    private String chosenName;
    private String givenName;
    private String familyName;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date dateOfBirth;
    @Indexed
    private String uid;
    private String schacHomeOrganization;
    private String password;
    private long passwordUpdatedAt;
    private boolean newUser;
    private String preferredLanguage;
    private String webAuthnIdentifier;
    private String userHandle;
    private boolean forgottenPassword;
    @Indexed
    private String enrollmentVerificationKey;
    @Indexed
    private String createFromInstitutionKey;
    private Map<String, List<String>> attributes = new HashMap();
    private Map<String, Object> surfSecureId = new HashMap();
    private List<PublicKeyCredentials> publicKeyCredentials = new ArrayList();
    private List<LinkedAccount> linkedAccounts = new ArrayList();
    private List<ExternalLinkedAccount> externalLinkedAccounts = new ArrayList();
    private List<EduID> eduIDS = new ArrayList();
    private long created;
    private long lastLogin;
    private boolean nudgeAppMailSend;
    private LocalDateTime institutionMailSendDate;
    @Indexed
    private String trackingUuid;
    private long lastSeenAppNudge;
    @Transient
    @JsonIgnore
    private boolean mobileAuthentication;
    private UserInactivity userInactivity;
    private boolean serviceDeskMember;
    private ControlCode controlCode;
    private OneTimeLoginCode oneTimeLoginCode;
    private boolean rateLimited;

    public User(CreateInstitutionEduID createInstitutionEduID, Map<String, Object> userInfo) {
        this.email = createInstitutionEduID.getEmail();
        this.chosenName = (String)userInfo.get("given_name");
        this.givenName = (String)userInfo.get("given_name");
        this.familyName = (String)userInfo.get("family_name");
    }

    public User(String uid, String email, String chosenName, String givenName, String familyName, String schacHomeOrganization, String preferredLanguage, String serviceProviderEntityId, Manage manage) {
        this.uid = uid;
        this.email = email;
        this.chosenName = chosenName;
        this.givenName = givenName;
        this.familyName = familyName;
        this.schacHomeOrganization = StringUtils.hasText((String)schacHomeOrganization) ? schacHomeOrganization.toLowerCase() : schacHomeOrganization;
        this.preferredLanguage = preferredLanguage;
        if (StringUtils.hasText((String)serviceProviderEntityId)) {
            this.computeEduIdForServiceProviderIfAbsent(serviceProviderEntityId, manage);
        }
        this.newUser = true;
        this.created = System.currentTimeMillis() / 1000L;
    }

    public User(String uid, String email, String chosenName, String givenName, String familyName, String schacHomeOrganization, String preferredLanguage, RemoteProvider remoteProvider, Manage manage) {
        this(uid, email, chosenName, givenName, familyName, schacHomeOrganization, preferredLanguage, (String)null, manage);
        this.computeEduIdForIdentityProviderProviderIfAbsent(remoteProvider, manage);
    }

    public void validate() {
        Assert.notNull((Object)this.email, (String)"Email is required");
        Assert.notNull((Object)this.givenName, (String)"GivenName is required");
        Assert.notNull((Object)this.familyName, (String)"FamilyName is required");
    }

    public void encryptPassword(String password, PasswordEncoder encoder) {
        if (!PasswordStrength.strongEnough((String)password)) {
            throw new WeakPasswordException("Weak password: " + password);
        }
        this.password = encoder.encode((CharSequence)password);
        this.passwordUpdatedAt = System.currentTimeMillis();
    }

    public void deletePassword() {
        this.password = null;
        this.passwordUpdatedAt = 0L;
    }

    @Transient
    public void addPublicKeyCredential(PublicKeyCredentialDescriptor publicKeyCredentialDescriptor, ByteArray publicKeyCredential, String name) {
        this.publicKeyCredentials.add(new PublicKeyCredentials(publicKeyCredentialDescriptor, publicKeyCredential, name));
    }

    @Transient
    public String computeEduIdForServiceProviderIfAbsent(String entityId, Manage manage) {
        ServiceProvider serviceProvider;
        try {
            serviceProvider = manage.findServiceProviderByEntityId(entityId).orElse(new ServiceProvider(new RemoteProvider(entityId, entityId, entityId, null, null), null));
        }
        catch (RuntimeException e) {
            serviceProvider = new ServiceProvider(new RemoteProvider(entityId, entityId, entityId, null, null), null);
        }
        return this.doComputeEduIDIfAbsent(serviceProvider, manage, false);
    }

    @Transient
    public String computeEduIdForIdentityProviderProviderIfAbsent(RemoteProvider remoteProvider, Manage manage) {
        remoteProvider.setEntityId(null);
        ServiceProvider serviceProvider = new ServiceProvider(remoteProvider, null);
        return this.doComputeEduIDIfAbsent(serviceProvider, manage, false);
    }

    @Transient
    public String doComputeEduIDIfAbsent(ServiceProvider serviceProvider, Manage manage, boolean isResourceServer) {
        this.lastLogin = System.currentTimeMillis();
        serviceProvider.setLastLogin(new Date());
        String institutionGuid = serviceProvider.getInstitutionGuid();
        String entityId = serviceProvider.getEntityId();
        Optional<EduID> optionalExistingEduID = this.eduIDS.stream().filter(eduID -> {
            boolean matchByInstitutionGUID = StringUtils.hasText((String)institutionGuid) && (institutionGuid.equals(eduID.getServiceInstutionGuid()) || eduID.getServices().stream().anyMatch(sp -> institutionGuid.equals(sp.getInstitutionGuid())));
            boolean matchByEntityId = StringUtils.hasText((String)entityId) && (entityId.equals(eduID.getServiceProviderEntityId()) || eduID.getServices().stream().anyMatch(sp -> entityId.equals(sp.getEntityId())));
            return matchByInstitutionGUID || matchByEntityId;
        }).findFirst();
        String eduIDValue = optionalExistingEduID.map(eduId -> isResourceServer ? eduId.getValue() : eduId.updateServiceProvider(serviceProvider).getValue()).orElseGet(() -> {
            EduID eduID = new EduID(UUID.randomUUID().toString(), serviceProvider);
            this.eduIDS.add(eduID);
            return eduID.getValue();
        });
        List<EduID> otherEduIDs = this.eduIDS.stream().filter(eduID -> !eduID.getValue().equals(eduIDValue)).filter(eduID -> eduID.getServices().isEmpty() && eduID.getServiceProviderEntityId() != null).toList();
        otherEduIDs.forEach(eduID -> {
            String otherEntityId = eduID.getServiceProviderEntityId();
            try {
                manage.findServiceProviderByEntityId(otherEntityId).ifPresent(arg_0 -> ((EduID)eduID).updateServiceProvider(arg_0));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        });
        return eduIDValue;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return GUEST_AUTHORITIES;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonIgnore
    public String getUsername() {
        return this.email;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    @Transient
    @JsonIgnore
    public List<LinkedAccount> linkedAccountsSorted() {
        return this.linkedAccounts.stream().sorted(Comparator.comparing(LinkedAccount::getExpiresAt).reversed()).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public List<String> allEduPersonAffiliations() {
        return this.linkedAccounts.stream().map(LinkedAccount::getEduPersonAffiliations).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public List<String> loginOptions() {
        ArrayList<LoginOptions> result = new ArrayList<LoginOptions>();
        if (!CollectionUtils.isEmpty((Map)this.surfSecureId) && (this.surfSecureId.containsKey("phone-verified") || this.surfSecureId.containsKey("recovery-code"))) {
            result.add(LoginOptions.APP);
        }
        if (!CollectionUtils.isEmpty((Collection)this.publicKeyCredentials)) {
            result.add(LoginOptions.FIDO);
        }
        if (StringUtils.hasText((String)this.password)) {
            result.add(LoginOptions.PASSWORD);
        }
        result.add(LoginOptions.CODE);
        return result.stream().map(LoginOptions::getValue).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public Map<String, EduID> convertEduIdPerServiceProvider(ServicesConfiguration servicesConfiguration) {
        HashMap<String, EduID> result = new HashMap<String, EduID>();
        List hideInOverview = servicesConfiguration.getHideInOverview();
        this.getEduIDS().forEach(eduID -> {
            if (CollectionUtils.isEmpty((Collection)eduID.getServices()) && StringUtils.hasText((String)eduID.getServiceProviderEntityId()) && !hideInOverview.contains(eduID.getServiceProviderEntityId()) && StringUtils.hasText((String)eduID.getServiceProviderEntityId())) {
                result.put(eduID.getServiceProviderEntityId(), (EduID)eduID);
            } else {
                eduID.getServices().stream().filter(service -> !hideInOverview.contains(service.getEntityId())).filter(service -> StringUtils.hasText((String)service.getEntityId())).forEach(service -> {
                    String entityId = service.getEntityId();
                    String key = StringUtils.hasText((String)entityId) ? entityId : service.getInstitutionGuid();
                    result.put(key, eduID.copy(key));
                });
            }
        });
        if (this.isMobileAuthentication()) {
            result.forEach((entityId, eduID) -> {
                if (!CollectionUtils.isEmpty((Collection)eduID.getServices())) {
                    ServiceProvider serviceProvider = eduID.getServices().stream().filter(sp -> entityId.equals(sp.getEntityId())).findFirst().orElse((ServiceProvider)eduID.getServices().get(0));
                    eduID.backwardCompatibleTransformation(serviceProvider);
                }
            });
        }
        return result;
    }

    @Transient
    @JsonIgnore
    public void updateWithExternalEduID(NewExternalEduID externalEduID) {
        if (CollectionUtils.isEmpty((Collection)this.externalLinkedAccounts) && CollectionUtils.isEmpty((Collection)this.linkedAccounts)) {
            this.givenName = externalEduID.getFirstName();
            String lastNamePrefix = externalEduID.getLastNamePrefix();
            this.familyName = StringUtils.hasText((String)lastNamePrefix) ? String.format("%s %s", lastNamePrefix, externalEduID.getLastName()) : externalEduID.getLastName();
            this.dateOfBirth = AttributeMapper.parseDate((String)externalEduID.getDateOfBirth());
        }
    }

    public String getEduPersonPrincipalName() {
        return this.uid + "@" + this.schacHomeOrganization;
    }

    @Transient
    @JsonIgnore
    public boolean reconcileLinkedAccounts() {
        ArrayList provisionedLinkedAccounts = new ArrayList();
        provisionedLinkedAccounts.addAll(this.linkedAccounts);
        provisionedLinkedAccounts.addAll(this.externalLinkedAccounts);
        boolean preferredInstitution = provisionedLinkedAccounts.stream().anyMatch(ProvisionedLinkedAccount::isPreferred);
        if (!preferredInstitution) {
            Optional<ProvisionedLinkedAccount> first = provisionedLinkedAccounts.stream().max(Comparator.comparing(ProvisionedLinkedAccount::getCreatedAt));
            first.ifPresent(provisionedLinkedAccount -> provisionedLinkedAccount.setPreferred(true));
            return first.isPresent();
        }
        return false;
    }

    private long getLastSeenAppNudge() {
        return this.lastSeenAppNudge;
    }

    @Transient
    @JsonIgnore
    public boolean nudgeToApp(int nudgeAppDays, int nudgeAppDelayDays) {
        boolean decision;
        int oneDayMillis = 86400000;
        long nowMillis = System.currentTimeMillis();
        long createdMillis = this.created * 1000L;
        long nudgeAppMillis = (long)nudgeAppDays * (long)oneDayMillis;
        boolean createdMoreThenOneDayAgo = createdMillis < nowMillis - (long)oneDayMillis;
        boolean secondLoginBeforeNudgeAppDays = this.lastSeenAppNudge == 0L && nowMillis - createdMillis < nudgeAppMillis;
        boolean delayReached = this.lastSeenAppNudge != 0L && nowMillis - this.lastSeenAppNudge > (long)oneDayMillis * (long)nudgeAppDelayDays;
        boolean cornerCase = createdMoreThenOneDayAgo && this.lastSeenAppNudge == 0L && nowMillis - this.lastLogin < nudgeAppMillis;
        boolean bl = decision = createdMoreThenOneDayAgo && (secondLoginBeforeNudgeAppDays || delayReached || cornerCase);
        if (decision) {
            this.lastSeenAppNudge = nowMillis;
        }
        return decision;
    }

    public Date getDerivedDateOfBirth() {
        return CollectionUtils.isEmpty((Collection)this.externalLinkedAccounts) ? null : ((ExternalLinkedAccount)this.externalLinkedAccounts.get(0)).getDateOfBirth();
    }

    public String getDerivedGivenName() {
        return this.getDerivedName(this.givenName, ProvisionedLinkedAccount::getGivenName);
    }

    public String getDerivedFamilyName() {
        return this.getDerivedName(this.familyName, ProvisionedLinkedAccount::getFamilyName);
    }

    private String getDerivedName(String fallback, ProvisionedNameProvider provisionedNameProvider) {
        if (CollectionUtils.isEmpty((Collection)this.linkedAccounts) && CollectionUtils.isEmpty((Collection)this.externalLinkedAccounts)) {
            return fallback;
        }
        ArrayList provisionedLinkedAccounts = new ArrayList();
        provisionedLinkedAccounts.addAll(this.linkedAccounts);
        provisionedLinkedAccounts.addAll(this.externalLinkedAccounts);
        return provisionedLinkedAccounts.stream().filter(ProvisionedLinkedAccount::isPreferred).findFirst().map(arg_0 -> ((ProvisionedNameProvider)provisionedNameProvider).derivedName(arg_0)).or(() -> provisionedLinkedAccounts.stream().filter(provisionedLinkedAccount -> provisionedLinkedAccount.getCreatedAt() != null).max(Comparator.comparing(ProvisionedLinkedAccount::getCreatedAt)).stream().findFirst().map(arg_0 -> ((ProvisionedNameProvider)provisionedNameProvider).derivedName(arg_0))).orElse(fallback);
    }

    public Map<String, Object> serviceDeskSummary() {
        return Map.of("name", String.format("%s %s", this.getDerivedGivenName(), this.getDerivedFamilyName()), "email", this.email, "serviceDeskMember", this.serviceDeskMember);
    }

    public void startOneTimeLoginCode(String oneTimeLoginCode) {
        this.oneTimeLoginCode = new OneTimeLoginCode(oneTimeLoginCode);
    }

    public void endOneTimeLoginCode() {
        if (this.oneTimeLoginCode != null) {
            this.oneTimeLoginCode.setCode(null);
        }
    }

    public boolean attemptOneTimeLoginVerification(String code) {
        boolean success = this.oneTimeLoginCode.attemptOneTimeLoginVerification(code);
        if (success) {
            this.oneTimeLoginCode = null;
        }
        return success;
    }

    @Generated
    public User() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getChosenName() {
        return this.chosenName;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public long getPasswordUpdatedAt() {
        return this.passwordUpdatedAt;
    }

    @Generated
    public boolean isNewUser() {
        return this.newUser;
    }

    @Generated
    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    @Generated
    public String getWebAuthnIdentifier() {
        return this.webAuthnIdentifier;
    }

    @Generated
    public String getUserHandle() {
        return this.userHandle;
    }

    @Generated
    public boolean isForgottenPassword() {
        return this.forgottenPassword;
    }

    @Generated
    public String getEnrollmentVerificationKey() {
        return this.enrollmentVerificationKey;
    }

    @Generated
    public String getCreateFromInstitutionKey() {
        return this.createFromInstitutionKey;
    }

    @Generated
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Map<String, Object> getSurfSecureId() {
        return this.surfSecureId;
    }

    @Generated
    public List<PublicKeyCredentials> getPublicKeyCredentials() {
        return this.publicKeyCredentials;
    }

    @Generated
    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @Generated
    public List<ExternalLinkedAccount> getExternalLinkedAccounts() {
        return this.externalLinkedAccounts;
    }

    @Generated
    public List<EduID> getEduIDS() {
        return this.eduIDS;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public long getLastLogin() {
        return this.lastLogin;
    }

    @Generated
    public boolean isNudgeAppMailSend() {
        return this.nudgeAppMailSend;
    }

    @Generated
    public LocalDateTime getInstitutionMailSendDate() {
        return this.institutionMailSendDate;
    }

    @Generated
    public String getTrackingUuid() {
        return this.trackingUuid;
    }

    @Generated
    public boolean isMobileAuthentication() {
        return this.mobileAuthentication;
    }

    @Generated
    public UserInactivity getUserInactivity() {
        return this.userInactivity;
    }

    @Generated
    public boolean isServiceDeskMember() {
        return this.serviceDeskMember;
    }

    @Generated
    public ControlCode getControlCode() {
        return this.controlCode;
    }

    @Generated
    public OneTimeLoginCode getOneTimeLoginCode() {
        return this.oneTimeLoginCode;
    }

    @Generated
    public boolean isRateLimited() {
        return this.rateLimited;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setChosenName(String chosenName) {
        this.chosenName = chosenName;
    }

    @Generated
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Generated
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Generated
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @Generated
    public void setNewUser(boolean newUser) {
        this.newUser = newUser;
    }

    @Generated
    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    @Generated
    public void setWebAuthnIdentifier(String webAuthnIdentifier) {
        this.webAuthnIdentifier = webAuthnIdentifier;
    }

    @Generated
    public void setUserHandle(String userHandle) {
        this.userHandle = userHandle;
    }

    @Generated
    public void setForgottenPassword(boolean forgottenPassword) {
        this.forgottenPassword = forgottenPassword;
    }

    @Generated
    public void setEnrollmentVerificationKey(String enrollmentVerificationKey) {
        this.enrollmentVerificationKey = enrollmentVerificationKey;
    }

    @Generated
    public void setCreateFromInstitutionKey(String createFromInstitutionKey) {
        this.createFromInstitutionKey = createFromInstitutionKey;
    }

    @Generated
    public void setPublicKeyCredentials(List<PublicKeyCredentials> publicKeyCredentials) {
        this.publicKeyCredentials = publicKeyCredentials;
    }

    @Generated
    public void setLinkedAccounts(List<LinkedAccount> linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    @Generated
    public void setExternalLinkedAccounts(List<ExternalLinkedAccount> externalLinkedAccounts) {
        this.externalLinkedAccounts = externalLinkedAccounts;
    }

    @Generated
    public void setEduIDS(List<EduID> eduIDS) {
        this.eduIDS = eduIDS;
    }

    @Generated
    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }

    @Generated
    public void setNudgeAppMailSend(boolean nudgeAppMailSend) {
        this.nudgeAppMailSend = nudgeAppMailSend;
    }

    @Generated
    public void setInstitutionMailSendDate(LocalDateTime institutionMailSendDate) {
        this.institutionMailSendDate = institutionMailSendDate;
    }

    @Generated
    public void setTrackingUuid(String trackingUuid) {
        this.trackingUuid = trackingUuid;
    }

    @JsonIgnore
    @Generated
    public void setMobileAuthentication(boolean mobileAuthentication) {
        this.mobileAuthentication = mobileAuthentication;
    }

    @Generated
    public void setUserInactivity(UserInactivity userInactivity) {
        this.userInactivity = userInactivity;
    }

    @Generated
    public void setServiceDeskMember(boolean serviceDeskMember) {
        this.serviceDeskMember = serviceDeskMember;
    }

    @Generated
    public void setControlCode(ControlCode controlCode) {
        this.controlCode = controlCode;
    }

    @Generated
    public void setOneTimeLoginCode(OneTimeLoginCode oneTimeLoginCode) {
        this.oneTimeLoginCode = oneTimeLoginCode;
    }

    @Generated
    public void setRateLimited(boolean rateLimited) {
        this.rateLimited = rateLimited;
    }
}

