/*
 * Decompiled with CFR 0.152.
 */
package myconext.mongo;

import com.github.cloudyrock.mongock.ChangeLog;
import com.github.cloudyrock.mongock.ChangeSet;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v4.decorator.impl.MongockTemplate;
import java.text.SimpleDateFormat;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import myconext.manage.Manage;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.PublicKeyCredentials;
import myconext.model.ServiceProvider;
import myconext.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ChangeLog(order="001")
public class Migrations {
    private static final Log LOG = LogFactory.getLog(Migrations.class);

    @ChangeSet(order="001", id="transformUserPublicKeyCredentials", author="okke.harsta@surf.nl")
    public void transformUserPublicKeyCredentials(MongockTemplate mongoTemplate) {
        List usersAsMaps = mongoTemplate.findAll(Map.class, "users");
        usersAsMaps.forEach(userAsMap -> {
            Map credentials;
            Object o;
            if (userAsMap.containsKey("publicKeyCredentials") && (o = userAsMap.get("publicKeyCredentials")) instanceof Map && !(credentials = (Map)userAsMap.get("publicKeyCredentials")).containsKey("name")) {
                List publicKeyCredentials = credentials.entrySet().stream().map(entry -> new PublicKeyCredentials((String)entry.getKey(), (String)entry.getValue(), "key-" + UUID.randomUUID().toString())).collect(Collectors.toList());
                userAsMap.put("publicKeyCredentials", publicKeyCredentials);
                mongoTemplate.save(userAsMap, "users");
            }
        });
    }

    @ChangeSet(order="002", id="transformEduIdPerServiceProvider", author="okke.harsta@surf.nl")
    public void transformEduIdPerServiceProvider(MongockTemplate mongoTemplate) {
    }

    @ChangeSet(order="003", id="bugfixForDotReplacement", author="okke.harsta@surf.nl")
    public void bugfixForDotReplacement(MongockTemplate mongoTemplate) {
        List users = mongoTemplate.findAll(User.class, "users");
        users.forEach(user -> {
            this.mergeEduIDs(user);
            mongoTemplate.save(user);
        });
    }

    @ChangeSet(order="004", id="addServiceProviderInstitutionGuid", author="okke.harsta@surf.nl")
    public void addServiceProviderInstitutionGuid(MongockTemplate mongoTemplate, Manage serviceProviderResolver) {
    }

    @ChangeSet(order="005", id="addTrackingGuid", author="okke.harsta@surf.nl")
    public void addTrackingGuid(MongockTemplate mongoTemplate) {
        List users = mongoTemplate.findAll(User.class, "users");
        users.forEach(user -> {
            if (!StringUtils.hasText((String)user.getTrackingUuid())) {
                user.setTrackingUuid(UUID.randomUUID().toString());
                mongoTemplate.save(user);
            }
        });
    }

    @ChangeSet(order="006", id="deleteSession", author="okke.harsta@surf.nl")
    public void deleteSession(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="007", id="expiresAtLinkedAccounts", author="okke.harsta@surf.nl")
    public void expiresAtLinkedAccounts(MongockTemplate mongoTemplate) {
        Criteria criteria = Criteria.where((String)"linkedAccounts").exists(true).type(new JsonSchemaObject.Type[]{JsonSchemaObject.Type.ARRAY}).ne(new ArrayList());
        List users = mongoTemplate.find(new Query((CriteriaDefinition)criteria), User.class, "users");
        users.forEach(user -> {
            user.getLinkedAccounts().forEach(linkedAccount -> {
                Date createdAt = linkedAccount.getCreatedAt();
                if (createdAt == null) {
                    createdAt = new Date();
                    linkedAccount.setCreatedAt(createdAt);
                }
                Date expiresAt = Date.from(createdAt.toInstant().plus(2190L, ChronoUnit.DAYS));
                linkedAccount.setExpiresAt(expiresAt);
            });
            mongoTemplate.save(user);
        });
    }

    @ChangeSet(order="008", id="deleteSessionAfterUserUpdate", author="okke.harsta@surf.nl")
    public void deleteSessionAfterUserUpdate(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="009", id="migrateUsers", author="okke.harsta@surf.nl")
    public void migrateUsers(MongockTemplate mongoTemplate) {
        Criteria criteria = Criteria.where((String)"linkedAccounts").exists(true).type(new JsonSchemaObject.Type[]{JsonSchemaObject.Type.ARRAY}).ne(new ArrayList());
        List users = mongoTemplate.find(new Query((CriteriaDefinition)criteria), User.class, "users");
        users.forEach(user -> user.linkedAccountsSorted().stream().filter(LinkedAccount::areNamesValidated).findFirst().ifPresent(linkedAccount -> {
            user.setGivenName(linkedAccount.getGivenName());
            user.setFamilyName(linkedAccount.getFamilyName());
            user.setChosenName(user.getGivenName());
            linkedAccount.setPreferred(true);
            mongoTemplate.save(user);
        }));
    }

    @ChangeSet(order="010", id="deleteSessionAgain", author="okke.harsta@surf.nl")
    public void deleteSessionAgain(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="011", id="deleteSessionOneMore", author="okke.harsta@surf.nl")
    public void deleteSessionOneMore(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="012", id="bugfixForFaultyMigration", author="okke.harsta@surf.nl")
    public void bugfixForFaultyMigration(MongockTemplate mongoTemplate) {
        List users = mongoTemplate.findAll(User.class, "users");
        users.forEach(user -> {
            if (!CollectionUtils.isEmpty((Collection)user.getEduIDS())) {
                AtomicBoolean userNeedsUpdate = new AtomicBoolean(false);
                user.getEduIDS().forEach(eduID -> {
                    if (!StringUtils.hasText((String)eduID.getServiceProviderEntityId()) && !CollectionUtils.isEmpty((Collection)eduID.getServices())) {
                        eduID.backwardCompatibleTransformation((ServiceProvider)eduID.getServices().get(0));
                        userNeedsUpdate.set(true);
                    }
                });
                if (userNeedsUpdate.get()) {
                    mongoTemplate.save(user);
                }
            }
        });
    }

    @ChangeSet(order="013", id="deleteSessionAfterUserChange", author="okke.harsta@surf.nl")
    public void deleteSessionAfterUserChange(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="014", id="markLinkedAccountsPreferred", author="okke.harsta@surf.nl")
    public void markLinkedAccountsPreferred(MongockTemplate mongoTemplate) {
        List users = mongoTemplate.findAll(User.class, "users");
        users.forEach(user -> {
            if (user.reconcileLinkedAccounts()) {
                mongoTemplate.save(user);
            }
        });
    }

    @ChangeSet(order="015", id="deleteSessionAfterUserChangeAgain", author="okke.harsta@surf.nl")
    public void deleteSessionAfterUserChangeAgain(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="016", id="alterUserLastLoginDate", author="okke.harsta@surf.nl")
    public void alterUserLastLoginDate(MongockTemplate mongoTemplate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
        long startMillis = simpleDateFormat.parse("29-10-2024").getTime();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"lastLogin").isNull());
        mongoTemplate.stream(query, Map.class, "users").forEach(userAsMap -> {
            Object updatedAtObject = userAsMap.get("updatedAt");
            userAsMap.remove("updatedAt");
            if (updatedAtObject == null) {
                userAsMap.put("lastLogin", startMillis);
            } else {
                long updatedAt = Long.parseLong(updatedAtObject.toString());
                if (updatedAt == 0L || updatedAt < startMillis) {
                    userAsMap.put("lastLogin", startMillis);
                } else {
                    userAsMap.put("lastLogin", updatedAt);
                }
            }
            mongoTemplate.save(userAsMap, "users");
        });
    }

    @ChangeSet(order="017", id="deleteSessionAfterUserLastLoginDate", author="okke.harsta@surf.nl")
    public void deleteSessionAfterUserLastLoginDate(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="018", id="deleteSessionAfterExternalLinkedAccountDocumentId", author="okke.harsta@surf.nl")
    public void deleteSessionAfterExternalLinkedAccountDocumentId(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="019", id="addRateLimitedToUsers", author="okke.harsta@surf.nl")
    public void addRateLimitedToUsers(MongockTemplate mongoTemplate) {
        mongoTemplate.stream(new Query(), Map.class, "users").forEach(userAsMap -> {
            userAsMap.put("rateLimited", false);
            mongoTemplate.save(userAsMap, "users");
        });
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="020", id="deleteSessionAfterUserInstitutionMailSendDate", author="leroy.vanzeeland@surf.nl")
    public void deleteSessionAfterUserInstitutionMailSendDate(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    protected User mergeEduIDs(User user) {
        List eduIDS = user.getEduIDS();
        ArrayList copiedEduIDs = new ArrayList(eduIDS);
        List<EduID> eduIDSFiltered = eduIDS.stream().filter(eduID -> {
            String entityId = eduID.getServiceProviderEntityId();
            boolean remove = false;
            boolean hasDot = entityId.contains(".");
            if (hasDot) {
                String oldEntityId = entityId.replaceAll("\\.", "@");
                remove = copiedEduIDs.stream().anyMatch(someEduID -> someEduID.getServiceProviderEntityId().equals(oldEntityId));
            }
            if (remove) {
                LOG.info((Object)("Removing " + String.valueOf(eduID) + " for user: " + user.getEmail()));
            }
            return !remove;
        }).collect(Collectors.toList());
        eduIDSFiltered.forEach(eduID -> eduID.replaceAtWithDot());
        user.setEduIDS(eduIDSFiltered);
        return user;
    }
}

