/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import myconext.security.RemoteUser;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ExtendedInMemoryUserDetailsManager
implements UserDetailsService {
    private final String NOOP_PREFIX = "{noop}";
    private final Map<String, RemoteUser> users;

    public ExtendedInMemoryUserDetailsManager(List<RemoteUser> users) {
        List wrongConfiguredRemoteUsers = users.stream().filter(remoteUser -> remoteUser.getPassword().contains("{noop}")).collect(Collectors.toList());
        if (!wrongConfiguredRemoteUsers.isEmpty()) {
            throw new IllegalArgumentException(String.format("Remote users found with {noop} password. This is a configuration mistake. Check: %s", wrongConfiguredRemoteUsers.stream().map(RemoteUser::getUsername).collect(Collectors.joining(","))));
        }
        this.users = users.stream().collect(Collectors.toMap(UserDetails::getUsername, Function.identity()));
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        RemoteUser remoteUser = (RemoteUser)this.users.get(username);
        if (remoteUser == null) {
            throw new UsernameNotFoundException("User not found: " + username);
        }
        RemoteUser remoteUserClone = new RemoteUser(remoteUser);
        remoteUserClone.setPassword("{noop}".concat(remoteUserClone.getPassword()));
        return remoteUserClone;
    }
}

