/*
 * Decompiled with CFR 0.152.
 */
package oidc.api;

import java.util.List;
import oidc.secure.KeyRollover;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminController {
    private static final Log LOG = LogFactory.getLog(AdminController.class);
    @Autowired
    private KeyRollover keyRollover;

    @GetMapping(value={"manage/force-signing-key-rollover"})
    @PreAuthorize(value="hasRole('ROLE_manage')")
    public ResponseEntity<List<String>> rolloverSigningKey(Authentication authentication) {
        String name = authentication.getName();
        LOG.info((Object)("Starting a forced signing key rollover by: " + name));
        List deleted = this.keyRollover.doSigningKeyRollover();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)deleted);
    }

    @GetMapping(value={"manage/force-symmetric-key-rollover"})
    @PreAuthorize(value="hasRole('ROLE_manage')")
    public ResponseEntity<List<String>> rolloverSymmetricKey(Authentication authentication) {
        String name = authentication.getName();
        LOG.info((Object)("Starting a forced symmetric key rollover by: " + name));
        List deleted = this.keyRollover.doSymmetricKeyRollover();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)deleted);
    }
}

