/*
 * Decompiled with CFR 0.152.
 */
package oidc.saml;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oidc.model.AuthenticationRequest;
import oidc.model.User;
import oidc.repository.AuthenticationRequestRepository;
import oidc.repository.UserRepository;
import oidc.user.OidcSamlAuthentication;
import oidc.user.UserAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.NameID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.Resource;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml5AuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ResponseAuthenticationConverter
implements Converter<OpenSaml5AuthenticationProvider.ResponseToken, OidcSamlAuthentication> {
    public static final Pattern inResponseToPattern = Pattern.compile("InResponseTo=\"(.+?)\"", 32);
    public static final Pattern idPattern = Pattern.compile("ID=\"(.+?)\"", 32);
    private static final Log LOG = LogFactory.getLog(ResponseAuthenticationConverter.class);
    private final Converter<OpenSaml5AuthenticationProvider.ResponseToken, Saml2Authentication> defaultResponseAuthenticationConverter;
    private final UserRepository userRepository;
    private final List<UserAttribute> userAttributes;
    private final AuthenticationRequestRepository authenticationRequestRepository;

    public ResponseAuthenticationConverter(UserRepository userRepository, AuthenticationRequestRepository authenticationRequestRepository, ObjectMapper objectMapper, Resource oidcSamlMapping) throws IOException {
        this.userRepository = userRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userAttributes = (List)objectMapper.readValue(oidcSamlMapping.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.defaultResponseAuthenticationConverter = OpenSaml5AuthenticationProvider.createDefaultResponseAuthenticationConverter();
    }

    public OidcSamlAuthentication convert(OpenSaml5AuthenticationProvider.ResponseToken responseToken) {
        Saml2Authentication authentication = (Saml2Authentication)this.defaultResponseAuthenticationConverter.convert((Object)responseToken);
        Assertion assertion = (Assertion)responseToken.getResponse().getAssertions().get(0);
        Matcher matcher = inResponseToPattern.matcher(authentication.getSaml2Response());
        boolean match = matcher.find();
        if (!match) {
            throw new SessionAuthenticationException("Invalid Authn Statement. Missing InResponseTo");
        }
        String authenticationRequestID = matcher.group(1);
        User user = this.buildUser(assertion, authenticationRequestID);
        Optional existingUserOptional = this.userRepository.findOptionalUserBySub(user.getSub());
        if (existingUserOptional.isPresent()) {
            User existingUser = (User)existingUserOptional.get();
            LOG.debug((Object)("Authenticate with existing user: " + String.valueOf(existingUser)));
            user.setId(existingUser.getId());
            if (!user.equals((Object)existingUser)) {
                LOG.debug((Object)("Saving existing user with changed attributes: " + String.valueOf(existingUser)));
                this.userRepository.save((Object)existingUser);
            }
        } else {
            LOG.debug((Object)("Provisioning new user : " + String.valueOf(user)));
            this.userRepository.insert((Object)user);
        }
        OidcSamlAuthentication oidcSamlAuthentication = new OidcSamlAuthentication(assertion, user, authenticationRequestID);
        return oidcSamlAuthentication;
    }

    private User buildUser(Assertion assertion, String authenticationRequestID) {
        String sub;
        List authnStatements = assertion.getAuthnStatements();
        String authenticatingAuthority = CollectionUtils.isEmpty((Collection)authnStatements) ? null : (String)authnStatements.stream().map(as -> as.getAuthnContext().getAuthenticatingAuthorities()).flatMap(Collection::stream).reduce((first, second) -> second).map(aa -> aa.getURI()).orElse(null);
        Map<String, Object> attributes = this.userAttributes.stream().filter(ua -> !ua.customMapping).map(ua -> new Object[]{ua.oidc, ua.multiValue ? this.getAttributeValues(ua.saml, assertion) : this.getAttributeValue(ua.saml, assertion)}).filter(oo -> oo[1] != null).collect(Collectors.toMap(oo -> (String)oo[0], oo -> oo[1], (r1, r2) -> r1));
        this.addDerivedAttributes(attributes);
        AuthenticationRequest authenticationRequest = (AuthenticationRequest)this.authenticationRequestRepository.findById((Object)authenticationRequestID).orElseThrow(() -> new IllegalArgumentException("No Authentication Request found for ID: " + authenticationRequestID));
        String clientId = authenticationRequest.getClientId();
        String nameId = assertion.getSubject().getNameID().getValue();
        String eduPersonTargetedId = this.getAttributeValue("urn:mace:dir:attribute-def:eduPersonTargetedID", assertion);
        String collabPersonId = this.getAttributeValue("urn:mace:surf.nl:attribute-def:internal-collabPersonId", assertion);
        if (StringUtils.hasText((String)collabPersonId)) {
            sub = nameId;
            nameId = collabPersonId;
        } else {
            sub = StringUtils.hasText((String)eduPersonTargetedId) ? eduPersonTargetedId : UUID.nameUUIDFromBytes((nameId + "_" + clientId).getBytes()).toString();
        }
        attributes.put("sub", sub);
        List acrClaims = assertion.getAuthnStatements().stream().map(authenticationStatement -> this.authenticationContextClassReference(authenticationStatement.getAuthnContext().getAuthnContextClassRef())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return new User(sub, nameId, authenticatingAuthority, clientId, attributes, acrClaims);
    }

    private void addDerivedAttributes(Map<String, Object> attributes) {
        if (attributes.containsKey("email")) {
            attributes.put("email_verified", true);
        }
    }

    private Optional<String> authenticationContextClassReference(AuthnContextClassRef authnContextClassRef) {
        return Optional.ofNullable(authnContextClassRef).map(XSURI::getURI);
    }

    private String getAttributeValue(String samlAttributeName, Assertion assertion) {
        List values = this.getAttributeValues(samlAttributeName, assertion);
        return !CollectionUtils.isEmpty((Collection)values) ? (String)values.get(0) : null;
    }

    private List<String> getAttributeValues(String samlAttributeName, Assertion assertion) {
        Optional<List> values = assertion.getAttributeStatements().stream().map(AttributeStatement::getAttributes).flatMap(Collection::stream).filter(attribute -> attribute.getName().equals(samlAttributeName)).findAny().map(attribute -> attribute.getAttributeValues().stream().map(xmlObject -> this.getXmlObjectValue(xmlObject)).filter(Objects::nonNull).map(val -> val.toString()).collect(Collectors.toList()));
        return values.orElse(null);
    }

    private Object getXmlObjectValue(XMLObject xmlObject) {
        if (xmlObject instanceof XSAny) {
            XMLObject unknownXMLObject;
            XSAny xsAny = (XSAny)xmlObject;
            String textContent = xsAny.getTextContent();
            if (StringUtils.hasText((String)textContent)) {
                return textContent;
            }
            List unknownXMLObjects = xsAny.getUnknownXMLObjects();
            if (!CollectionUtils.isEmpty((Collection)unknownXMLObjects) && (unknownXMLObject = (XMLObject)unknownXMLObjects.get(0)) instanceof NameID) {
                NameID nameID = (NameID)unknownXMLObject;
                return nameID.getValue();
            }
        }
        if (xmlObject instanceof XSString) {
            return ((XSString)xmlObject).getValue();
        }
        if (xmlObject instanceof XSInteger) {
            return ((XSInteger)xmlObject).getValue();
        }
        if (xmlObject instanceof XSURI) {
            return ((XSURI)xmlObject).getURI();
        }
        if (xmlObject instanceof XSBoolean) {
            XSBooleanValue xsBooleanValue = ((XSBoolean)xmlObject).getValue();
            return xsBooleanValue != null ? xsBooleanValue.getValue() : null;
        }
        if (xmlObject instanceof XSDateTime) {
            return ((XSDateTime)xmlObject).getValue();
        }
        return null;
    }
}

