/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;
import pdp.domain.CidrNotation;
import pdp.domain.PdpAttribute;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoA {
    private String level;
    private boolean allAttributesMustMatch;
    private boolean negateCidrNotation;
    @Valid
    private List<PdpAttribute> attributes = new ArrayList();
    @Valid
    private List<CidrNotation> cidrNotations = new ArrayList();

    @JsonIgnore
    public List<String> anyCidrNotations() {
        return CollectionUtils.isEmpty((Collection)this.cidrNotations) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonIgnore
    public List<String> anyAttributes() {
        return CollectionUtils.isEmpty((Collection)this.attributes) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonIgnore
    public boolean empty() {
        return CollectionUtils.isEmpty((Collection)this.cidrNotations) && CollectionUtils.isEmpty((Collection)this.attributes);
    }

    @JsonIgnore
    public Set<Map.Entry<Map.Entry<String, Integer>, List<PdpAttribute>>> allAttributesGrouped() {
        return this.attributes.stream().collect(Collectors.groupingBy(attribute -> Map.entry(attribute.getName(), attribute.getGroupID()))).entrySet();
    }

    @Generated
    public LoA(String level, boolean allAttributesMustMatch, boolean negateCidrNotation, List<PdpAttribute> attributes, List<CidrNotation> cidrNotations) {
        this.level = level;
        this.allAttributesMustMatch = allAttributesMustMatch;
        this.negateCidrNotation = negateCidrNotation;
        this.attributes = attributes;
        this.cidrNotations = cidrNotations;
    }

    @Generated
    public LoA() {
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public boolean isAllAttributesMustMatch() {
        return this.allAttributesMustMatch;
    }

    @Generated
    public boolean isNegateCidrNotation() {
        return this.negateCidrNotation;
    }

    @Generated
    public List<PdpAttribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<CidrNotation> getCidrNotations() {
        return this.cidrNotations;
    }

    @Generated
    public void setLevel(String level) {
        this.level = level;
    }

    @Generated
    public void setAllAttributesMustMatch(boolean allAttributesMustMatch) {
        this.allAttributesMustMatch = allAttributesMustMatch;
    }

    @Generated
    public void setNegateCidrNotation(boolean negateCidrNotation) {
        this.negateCidrNotation = negateCidrNotation;
    }

    @Generated
    public void setAttributes(List<PdpAttribute> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setCidrNotations(List<CidrNotation> cidrNotations) {
        this.cidrNotations = cidrNotations;
    }
}

