/*
 * Decompiled with CFR 0.152.
 */
package pdp.negate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinition;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypeBoolean;
import org.springframework.util.StringUtils;

public class NegateFunctionDefinition
implements FunctionDefinition {
    private static final IdentifierImpl IDENTIFIER = new IdentifierImpl("urn:surfnet:cbac:custom:function:3.0:negation");

    public Identifier getId() {
        return IDENTIFIER;
    }

    public Identifier getDataTypeId() {
        return XACML.ID_DATATYPE_BOOLEAN;
    }

    public boolean returnsBag() {
        return false;
    }

    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        List<Object> allValues;
        if (arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR));
        }
        String policyValue = (String)arguments.get(0).getValue().getValue();
        FunctionArgument functionArgument = arguments.get(1);
        Bag bag = functionArgument.getBag();
        if (bag != null) {
            Iterator attributeValuesIterator = bag.getAttributeValues();
            ArrayList attributeValues = new ArrayList();
            attributeValuesIterator.forEachRemaining(attributeValue -> attributeValues.add(attributeValue));
            allValues = attributeValues.stream().filter(Objects::nonNull).map(AttributeValue::getValue).filter(StringUtils::hasText).collect(Collectors.toList());
        } else {
            String value2 = (String)functionArgument.getValue().getValue();
            allValues = StringUtils.hasText((String)value2) ? List.of(value2) : Collections.emptyList();
        }
        boolean anyMatch = allValues.stream().anyMatch(value -> value.equalsIgnoreCase(policyValue));
        AttributeValue booleanAttributeValue = anyMatch ? DataTypeBoolean.AV_FALSE : DataTypeBoolean.AV_TRUE;
        return ExpressionResult.newSingle((AttributeValue)booleanAttributeValue);
    }
}

