/*
 * Decompiled with CFR 0.152.
 */
package pdp.xacml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.pip.StdMutablePIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;
import org.apache.openaz.xacml.std.pip.StdSinglePIPResponse;
import org.apache.openaz.xacml.std.pip.engines.ConfigurableEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import pdp.stats.StatsContext;
import pdp.stats.StatsContextHolder;

public abstract class AbstractConfigurableEngine
implements ConfigurableEngine {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected PIPRequest requiredAttributeUnspecifiedURN;
    protected PIPRequest requiredAttributeSchacHome;
    protected PIPRequest requiredAttributeUID;
    protected PIPRequest providedAttribute;
    protected PIPResponse empty;
    protected PIPResponse missingNameId;

    public void configure(String id, Properties properties) throws PIPException {
        IdentifierImpl identifierDataType = new IdentifierImpl("http://www.w3.org/2001/XMLSchema#string");
        IdentifierImpl attributeCategory = new IdentifierImpl("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        this.requiredAttributeUnspecifiedURN = new StdPIPRequest((Identifier)attributeCategory, (Identifier)new IdentifierImpl("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"), (Identifier)identifierDataType);
        this.requiredAttributeSchacHome = new StdPIPRequest((Identifier)attributeCategory, (Identifier)new IdentifierImpl("urn:mace:terena.org:attribute-def:schacHomeOrganization"), (Identifier)identifierDataType);
        this.requiredAttributeUID = new StdPIPRequest((Identifier)attributeCategory, (Identifier)new IdentifierImpl("urn:mace:dir:attribute-def:uid"), (Identifier)identifierDataType);
        IdentifierImpl identifierAttribute = new IdentifierImpl(this.getIdentifierProvidedAttribute());
        this.providedAttribute = new StdPIPRequest((Identifier)attributeCategory, (Identifier)identifierAttribute, (Identifier)identifierDataType);
        StdAttribute attribute = new StdAttribute((Identifier)attributeCategory, (Identifier)identifierAttribute, Collections.emptyList(), null, true);
        this.empty = new StdSinglePIPResponse((Attribute)attribute);
        this.missingNameId = new StdMutablePIPResponse((Status)new StdStatus(StdStatusCode.STATUS_CODE_MISSING_ATTRIBUTE, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified attribute missing"));
    }

    public Collection<PIPRequest> attributesRequired() {
        if (this.useUnspecifiedURN()) {
            return List.of(this.requiredAttributeUnspecifiedURN);
        }
        return List.of(this.requiredAttributeSchacHome, this.requiredAttributeUID);
    }

    public Collection<PIPRequest> attributesProvided() {
        return Arrays.asList(this.providedAttribute);
    }

    public PIPResponse getAttributes(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        String userUrn;
        if (!this.getIdentifierProvidedAttribute().equals(pipRequest.getAttributeId().getUri().toString())) {
            return this.empty;
        }
        if (this.useUnspecifiedURN()) {
            Optional userUrnOptional = this.getAttribute(this.requiredAttributeUnspecifiedURN, pipFinder);
            if (!userUrnOptional.isPresent()) {
                return this.missingNameId;
            }
            userUrn = (String)userUrnOptional.get();
        } else {
            Optional schacHomeOptional = this.getAttribute(this.requiredAttributeSchacHome, pipFinder);
            if (!schacHomeOptional.isPresent()) {
                return this.missingNameId;
            }
            Optional uidOptional = this.getAttribute(this.requiredAttributeUID, pipFinder);
            if (!uidOptional.isPresent()) {
                return this.missingNameId;
            }
            userUrn = String.format("urn:collab:person:%s:%s", schacHomeOptional.get(), uidOptional.get());
        }
        StatsContext stats = StatsContextHolder.getContext();
        long start = System.currentTimeMillis();
        List result = this.getAttributes(userUrn);
        long ms = System.currentTimeMillis() - start;
        stats.addPipResponse(this.getName(), ms);
        this.LOG.info("{} PIP response for {} took {} ms", new Object[]{this.getName(), userUrn, ms});
        if (CollectionUtils.isEmpty((Collection)result)) {
            return this.empty;
        }
        Identifier dataTypeId = this.providedAttribute.getDataTypeId();
        List stdAttributeValues = result.stream().map(valueIn -> new StdAttributeValue(dataTypeId, valueIn)).collect(Collectors.toList());
        StdAttribute responseAttr = new StdAttribute(this.providedAttribute.getCategory(), this.providedAttribute.getAttributeId(), stdAttributeValues, null, true);
        this.LOG.debug("Returning result from PIP {}: {}", (Object)this.getName(), (Object)result);
        return new StdSinglePIPResponse((Attribute)responseAttr);
    }

    private Optional<String> getAttribute(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        PIPResponse matchingAttributes = pipFinder.getMatchingAttributes(pipRequest, (PIPEngine)this);
        Optional nameAttributeOptional = matchingAttributes.getAttributes().stream().findFirst();
        if (nameAttributeOptional.isEmpty() || CollectionUtils.isEmpty((Collection)((Attribute)nameAttributeOptional.get()).getValues())) {
            return Optional.empty();
        }
        return Optional.of((String)((AttributeValue)((Attribute)nameAttributeOptional.get()).getValues().stream().findFirst().get()).getValue());
    }

    protected abstract List<Object> getAttributes(String var1);

    public abstract String getIdentifierProvidedAttribute();

    public abstract boolean useUnspecifiedURN();
}

