/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;
import pdp.domain.LoA;
import pdp.domain.PdpAttribute;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PdpPolicyDefinition {
    private String id;
    private String policyId;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String name;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String description;
    private List<String> serviceProviderIds = new ArrayList();
    private boolean serviceProvidersNegated;
    private boolean serviceProviderInvalidOrMissing;
    private List<String> identityProviderIds = new ArrayList();
    private String clientId;
    @Valid
    private List<PdpAttribute> attributes = new ArrayList();
    @Valid
    private List<LoA> loas = new ArrayList();
    private String denyAdvice;
    private boolean denyRule;
    private boolean allAttributesMustMatch;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private Date created;
    private String userDisplayName;
    private String authenticatingAuthorityName;
    private int numberOfViolations;
    private int numberOfRevisions;
    private String denyAdviceNl;
    private int revisionNbr;
    private boolean isActivatedSr;
    private boolean active;
    private boolean actionsAllowed;
    private String type;
    private Long parentId;

    @JsonIgnore
    public List<String> anyIdentityProviders() {
        return CollectionUtils.isEmpty((Collection)this.identityProviderIds) ? Collections.emptyList() : List.of("will-iterate-once");
    }

    @JsonIgnore
    public List<String> anyServiceProviders() {
        return CollectionUtils.isEmpty((Collection)this.serviceProviderIds) ? Collections.emptyList() : List.of("will-iterate-once");
    }

    @JsonIgnore
    public Set<Map.Entry<Map.Entry<String, Integer>, List<PdpAttribute>>> allAttributesGrouped() {
        return this.attributes.stream().collect(Collectors.groupingBy(attribute -> Map.entry(attribute.getName(), attribute.getGroupID()))).entrySet();
    }

    @JsonIgnore
    public boolean isIdpOnly() {
        return this.identityProviderIds != null && !this.identityProviderIds.isEmpty();
    }

    @JsonIgnore
    public void sortLoas() {
        Collections.sort(this.loas, Comparator.comparing(LoA::getLevel).reversed());
    }

    @JsonIgnore
    public void sortAttributes() {
        Collections.sort(this.attributes, Comparator.comparing(PdpAttribute::getName));
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getPolicyId() {
        return this.policyId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getServiceProviderIds() {
        return this.serviceProviderIds;
    }

    @Generated
    public boolean isServiceProvidersNegated() {
        return this.serviceProvidersNegated;
    }

    @Generated
    public boolean isServiceProviderInvalidOrMissing() {
        return this.serviceProviderInvalidOrMissing;
    }

    @Generated
    public List<String> getIdentityProviderIds() {
        return this.identityProviderIds;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public List<PdpAttribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<LoA> getLoas() {
        return this.loas;
    }

    @Generated
    public String getDenyAdvice() {
        return this.denyAdvice;
    }

    @Generated
    public boolean isDenyRule() {
        return this.denyRule;
    }

    @Generated
    public boolean isAllAttributesMustMatch() {
        return this.allAttributesMustMatch;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    @Generated
    public String getAuthenticatingAuthorityName() {
        return this.authenticatingAuthorityName;
    }

    @Generated
    public int getNumberOfViolations() {
        return this.numberOfViolations;
    }

    @Generated
    public int getNumberOfRevisions() {
        return this.numberOfRevisions;
    }

    @Generated
    public String getDenyAdviceNl() {
        return this.denyAdviceNl;
    }

    @Generated
    public int getRevisionNbr() {
        return this.revisionNbr;
    }

    @Generated
    public boolean isActivatedSr() {
        return this.isActivatedSr;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public boolean isActionsAllowed() {
        return this.actionsAllowed;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getParentId() {
        return this.parentId;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setServiceProviderIds(List<String> serviceProviderIds) {
        this.serviceProviderIds = serviceProviderIds;
    }

    @Generated
    public void setServiceProvidersNegated(boolean serviceProvidersNegated) {
        this.serviceProvidersNegated = serviceProvidersNegated;
    }

    @Generated
    public void setServiceProviderInvalidOrMissing(boolean serviceProviderInvalidOrMissing) {
        this.serviceProviderInvalidOrMissing = serviceProviderInvalidOrMissing;
    }

    @Generated
    public void setIdentityProviderIds(List<String> identityProviderIds) {
        this.identityProviderIds = identityProviderIds;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setAttributes(List<PdpAttribute> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setLoas(List<LoA> loas) {
        this.loas = loas;
    }

    @Generated
    public void setDenyAdvice(String denyAdvice) {
        this.denyAdvice = denyAdvice;
    }

    @Generated
    public void setDenyRule(boolean denyRule) {
        this.denyRule = denyRule;
    }

    @Generated
    public void setAllAttributesMustMatch(boolean allAttributesMustMatch) {
        this.allAttributesMustMatch = allAttributesMustMatch;
    }

    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @Generated
    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @Generated
    public void setAuthenticatingAuthorityName(String authenticatingAuthorityName) {
        this.authenticatingAuthorityName = authenticatingAuthorityName;
    }

    @Generated
    public void setNumberOfViolations(int numberOfViolations) {
        this.numberOfViolations = numberOfViolations;
    }

    @Generated
    public void setNumberOfRevisions(int numberOfRevisions) {
        this.numberOfRevisions = numberOfRevisions;
    }

    @Generated
    public void setDenyAdviceNl(String denyAdviceNl) {
        this.denyAdviceNl = denyAdviceNl;
    }

    @Generated
    public void setRevisionNbr(int revisionNbr) {
        this.revisionNbr = revisionNbr;
    }

    @Generated
    public void setActivatedSr(boolean isActivatedSr) {
        this.isActivatedSr = isActivatedSr;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setActionsAllowed(boolean actionsAllowed) {
        this.actionsAllowed = actionsAllowed;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Generated
    public String toString() {
        return "PdpPolicyDefinition(id=" + this.getId() + ", policyId=" + this.getPolicyId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", serviceProviderIds=" + String.valueOf(this.getServiceProviderIds()) + ", serviceProvidersNegated=" + this.isServiceProvidersNegated() + ", serviceProviderInvalidOrMissing=" + this.isServiceProviderInvalidOrMissing() + ", identityProviderIds=" + String.valueOf(this.getIdentityProviderIds()) + ", clientId=" + this.getClientId() + ", attributes=" + String.valueOf(this.getAttributes()) + ", loas=" + String.valueOf(this.getLoas()) + ", denyAdvice=" + this.getDenyAdvice() + ", denyRule=" + this.isDenyRule() + ", allAttributesMustMatch=" + this.isAllAttributesMustMatch() + ", created=" + String.valueOf(this.getCreated()) + ", userDisplayName=" + this.getUserDisplayName() + ", authenticatingAuthorityName=" + this.getAuthenticatingAuthorityName() + ", numberOfViolations=" + this.getNumberOfViolations() + ", numberOfRevisions=" + this.getNumberOfRevisions() + ", denyAdviceNl=" + this.getDenyAdviceNl() + ", revisionNbr=" + this.getRevisionNbr() + ", isActivatedSr=" + this.isActivatedSr() + ", active=" + this.isActive() + ", actionsAllowed=" + this.isActionsAllowed() + ", type=" + this.getType() + ", parentId=" + this.getParentId() + ")";
    }
}

