/*
 * Decompiled with CFR 0.152.
 */
package pdp.stats;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pdp.stats.StatsContext;

public class StatsContextHolder
implements ServletRequestListener {
    private static final ThreadLocal<StatsContext> contextHolder = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger((String)"analytics");
    private final String path;
    private final ObjectMapper objectMapper;

    public StatsContextHolder(String path, ObjectMapper objectMapper) {
        this.path = path;
        this.objectMapper = objectMapper;
    }

    public void requestInitialized(ServletRequestEvent sre) {
        if (this.applyForPath(sre)) {
            contextHolder.set(new StatsContext());
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        if (this.applyForPath(sre)) {
            StatsContext context = (StatsContext)contextHolder.get();
            new Thread(() -> this.saveContext(context)).start();
            contextHolder.remove();
        }
    }

    private void saveContext(StatsContext context) {
        if (context.getServiceProvider() == null) {
            return;
        }
        try {
            logger.info(this.objectMapper.writeValueAsString((Object)context));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean applyForPath(ServletRequestEvent sre) {
        return ((HttpServletRequest)sre.getServletRequest()).getRequestURI().endsWith(this.path);
    }

    public static StatsContext getContext() {
        StatsContext ctx = (StatsContext)contextHolder.get();
        if (ctx == null) {
            contextHolder.set(new StatsContext());
        }
        return (StatsContext)contextHolder.get();
    }
}

