/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.Transactional;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.StdMutableRequest;
import org.apache.openaz.xacml.std.StdMutableRequestAttributes;
import org.apache.openaz.xacml.std.StdRequest;
import org.apache.openaz.xacml.std.json.JSONRequest;
import org.apache.openaz.xacml.std.json.JSONResponse;
import org.apache.openaz.xacml.util.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.domain.PdpPolicyPushVersion;
import pdp.repositories.PdpPolicyPushVersionRepository;
import pdp.repositories.PdpPolicyRepository;
import pdp.stats.StatsContext;
import pdp.stats.StatsContextHolder;
import pdp.util.StreamUtils;
import pdp.xacml.PDPEngineHolder;
import pdp.xacml.PdpPolicyDefinitionParser;
import pdp.xacml.PolicyTemplateEngine;

@RestController
@RequestMapping(value={"/pdp/api"}, headers={"Content-Type=application/json"}, produces={"application/json"})
public class PdpController {
    private static final Logger LOG = LoggerFactory.getLogger(PdpController.class);
    private final PDPEngineHolder pdpEngineHolder;
    private final PdpPolicyRepository pdpPolicyRepository;
    private final PolicyTemplateEngine policyTemplateEngine = new PolicyTemplateEngine();
    private final PdpPolicyDefinitionParser pdpPolicyDefinitionParser = new PdpPolicyDefinitionParser();
    private final ReentrantLock lock = new ReentrantLock();
    private final PdpPolicyPushVersionRepository pdpPolicyPushVersionRepository;
    private volatile PDPEngine pdpEngine;
    private final AtomicLong policiesPushVersion = new AtomicLong();

    @Autowired
    public PdpController(PdpPolicyRepository pdpPolicyRepository, PDPEngineHolder pdpEngineHolder, PdpPolicyPushVersionRepository pdpPolicyPushVersionRepository) {
        this.pdpEngineHolder = pdpEngineHolder;
        this.pdpEngine = pdpEngineHolder.newPdpEngine(false);
        this.pdpPolicyRepository = pdpPolicyRepository;
        this.pdpPolicyPushVersionRepository = pdpPolicyPushVersionRepository;
        this.policiesPushVersion.set(((PdpPolicyPushVersion)pdpPolicyPushVersionRepository.findById((Object)1L).get()).getVersion());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/decide/policy"})
    public String decide(@RequestBody String payload) throws Exception {
        Long currentDatabasePoliciesPushVersion = this.pdpPolicyPushVersionRepository.getCurrentVersion();
        if (currentDatabasePoliciesPushVersion.longValue() != this.policiesPushVersion.get()) {
            this.refreshPolicies(false);
        }
        return this.doDecide(payload);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/manage/decide"})
    public String decideManage(@RequestBody String payload) throws Exception {
        return this.decide(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doDecide(String payload) throws Exception {
        Response pdpResponse;
        StatsContext stats = StatsContextHolder.getContext();
        long start = System.currentTimeMillis();
        LOG.debug("decide request: {}", (Object)payload);
        Request request = JSONRequest.load((String)payload);
        this.addStatsDetails(stats, request);
        this.returnPolicyIdInList(request);
        this.lock.lock();
        try {
            pdpResponse = this.pdpEngine.decide(request);
        }
        finally {
            this.lock.unlock();
        }
        String response = JSONResponse.toString((Response)pdpResponse, (boolean)LOG.isDebugEnabled());
        long took = System.currentTimeMillis() - start;
        stats.setResponseTimeMs(took);
        LOG.debug("decide response: {} took: {} ms", (Object)response, (Object)took);
        this.provideStatsContext(stats, pdpResponse);
        return response;
    }

    private void returnPolicyIdInList(Request request) {
        StdRequest.class.cast(request);
        Field field = ReflectionUtils.findField(Wrapper.class, (String)"wrappedObject");
        ReflectionUtils.makeAccessible((Field)field);
        StdMutableRequest mutableRequest = (StdMutableRequest)StdMutableRequest.class.cast(ReflectionUtils.getField((Field)field, (Object)request));
        mutableRequest.setReturnPolicyIdList(true);
        StdMutableRequestAttributes requestAttributes = (StdMutableRequestAttributes)mutableRequest.getRequestAttributes().stream().filter(requestAttribute -> requestAttribute.getCategory().getUri().toString().equals("urn:oasis:names:tc:xacml:3.0:attribute-category:resource")).findFirst().get();
        Collection attributes = requestAttributes.getAttributes();
        boolean clientIDPresent = attributes.stream().anyMatch(attribute -> attribute.getAttributeId().getUri().toString().equals("ClientID"));
        if (!clientIDPresent) {
            requestAttributes.add((Attribute)new StdAttribute((Attribute)new StdMutableAttribute((Identifier)new IdentifierImpl("urn:oasis:names:tc:xacml:3.0:attribute-category:resource"), (Identifier)new IdentifierImpl("ClientID"), (AttributeValue)new StdAttributeValue((Identifier)new IdentifierImpl("http://www.w3.org/2001/XMLSchema#string"), (Object)"EngineBlock"))));
        }
    }

    private void provideStatsContext(StatsContext stats, Response pdpResponse) {
        Result result = (Result)pdpResponse.getResults().iterator().next();
        stats.setDecision(result.getDecision().toString());
        Optional optionalLoa = this.getOptionalLoa(pdpResponse);
        optionalLoa.ifPresent(arg_0 -> ((StatsContext)stats).setLoa(arg_0));
        Optional optionalPolicyId = this.getPolicyId(result);
        optionalPolicyId.ifPresent(policyId -> stats.setPolicyId(policyId.getId().getUri().toString()));
    }

    @RequestMapping(method={RequestMethod.OPTIONS}, value={"/protected/policies"})
    public ResponseEntity<Void> options(HttpServletResponse response) {
        response.setHeader("Allow", Joiner.on((String)",").join((Iterable)ImmutableList.of((Object)RequestMethod.GET, (Object)RequestMethod.POST, (Object)RequestMethod.PUT, (Object)RequestMethod.DELETE)));
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/manage/push"})
    @Transactional
    public void pushPolicyDefinitions(@RequestBody List<PdpPolicyDefinition> policyDefinitions) {
        LOG.info("/manage/push");
        List policies = policyDefinitions.stream().map(policyDefinition -> {
            String policyXml = this.policyTemplateEngine.createPolicyXml(policyDefinition);
            Policy parsedPolicy = this.pdpPolicyDefinitionParser.parsePolicy(policyXml, policyDefinition.getName());
            Assert.notNull((Object)parsedPolicy, (String)"ParsedPolicy is not valid");
            return new PdpPolicy(policyXml, policyDefinition.getName(), policyDefinition.isActive(), policyDefinition.getType());
        }).collect(Collectors.toList());
        LOG.info("/manage/push saved policies:" + policies.size());
        this.pdpPolicyRepository.deleteAll();
        this.pdpPolicyRepository.saveAll(policies);
        this.refreshPolicies(true);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/manage/parse"})
    public ResponseEntity<String> parsePolicyDefinition(@RequestBody PdpPolicyDefinition policyDefinition) {
        LOG.info("/manage/parse");
        String policyXml = this.policyTemplateEngine.createPolicyXml(policyDefinition);
        return ResponseEntity.ok((Object)policyXml);
    }

    private void addStatsDetails(StatsContext stats, Request request) {
        RequestAttributes req = (RequestAttributes)request.getRequestAttributes().stream().filter(ra -> ra.getCategory().getUri().toString().equals("urn:oasis:names:tc:xacml:3.0:attribute-category:resource")).collect(StreamUtils.singletonCollector());
        Collection attributes = req.getAttributes();
        stats.setIdentityProvider(this.getAttributeValue(attributes, "IDPentityID").orElse(""));
        stats.setServiceProvider(this.getAttributeValue(attributes, "SPentityID").orElse(""));
    }

    private Optional<String> getAttributeValue(Collection<Attribute> attributes, String attributeId) {
        Optional attribute = (Optional)attributes.stream().filter(attr -> attr.getAttributeId().getUri().toString().equals(attributeId)).collect(StreamUtils.singletonOptionalCollector());
        return attribute.map(attr -> (String)((AttributeValue)attr.getValues().iterator().next()).getValue());
    }

    private Optional<String> getOptionalLoa(Response pdpResponse) {
        return pdpResponse.getResults().stream().flatMap(result -> result.getObligations().stream().map(obligation -> obligation.getAttributeAssignments().stream().map(attributeAssignment -> (String)String.class.cast(attributeAssignment.getAttributeValue().getValue())))).flatMap(Function.identity()).max(Comparator.naturalOrder());
    }

    private Optional<IdReference> getPolicyId(Result deniesOrIndeterminate) {
        Collection policyIdentifiers = deniesOrIndeterminate.getPolicyIdentifiers();
        Collection policySetIdentifiers = deniesOrIndeterminate.getPolicySetIdentifiers();
        return !CollectionUtils.isEmpty((Collection)policyIdentifiers) ? (Optional)policyIdentifiers.stream().collect(StreamUtils.singletonOptionalCollector()) : (Optional)policySetIdentifiers.stream().collect(StreamUtils.singletonOptionalCollector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPolicies(boolean incrementDatabase) {
        LOG.info("Starting reloading policies with increment database {}", (Object)incrementDatabase);
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            if (incrementDatabase) {
                this.pdpPolicyPushVersionRepository.incrementVersion();
            }
            Long newDatabasePoliciesPushVersion = this.pdpPolicyPushVersionRepository.getCurrentVersion();
            LOG.info("Updating new DB policy push version, old memory value {}, new value database {}", (Object)this.policiesPushVersion.get(), (Object)newDatabasePoliciesPushVersion);
            this.policiesPushVersion.set(newDatabasePoliciesPushVersion);
            this.pdpEngine = this.pdpEngineHolder.newPdpEngine(false);
            LOG.info("Finished reloading policies in {} ms", (Object)(System.currentTimeMillis() - start));
        }
        finally {
            this.lock.unlock();
        }
    }
}

