/*
 * Decompiled with CFR 0.152.
 */
package pdp.bag;

import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinition;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.datatypes.DataTypeBoolean;

public class BagFunctionDefinition
implements FunctionDefinition {
    private static final IdentifierImpl IDENTIFIER = new IdentifierImpl("urn:surfnet:cbac:custom:function:3.0:bag");

    public Identifier getId() {
        return IDENTIFIER;
    }

    public Identifier getDataTypeId() {
        return XACML.ID_DATATYPE_BOOLEAN;
    }

    public boolean returnsBag() {
        return false;
    }

    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        String actualValue = (String)arguments.get(0).getValue().getValue();
        List<String> policyValues = arguments.subList(1, arguments.size()).stream().map(arg -> (String)arg.getValue().getValue()).toList();
        boolean anyMatch = policyValues.contains(actualValue);
        AttributeValue booleanAttributeValue = anyMatch ? DataTypeBoolean.AV_TRUE : DataTypeBoolean.AV_FALSE;
        return ExpressionResult.newSingle((AttributeValue)booleanAttributeValue);
    }
}

