/*
 * Decompiled with CFR 0.152.
 */
package broker;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.session.JdbcSessionDataSourceScriptDatabaseInitializer;
import org.springframework.boot.autoconfigure.session.JdbcSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionAutoConfiguration;
import org.springframework.boot.sql.init.DatabaseInitializationMode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;

@Configuration
@ConditionalOnProperty(value={"database-session-enabled"}, havingValue="true", matchIfMissing=false)
@Import(value={SessionAutoConfiguration.class})
@EnableJdbcHttpSession(maxInactiveIntervalInSeconds=28800)
public class HttpSessionConfig {
    @Bean
    DataSource dataSource(@Value(value="${datasource.driver-class-name}") String driver, @Value(value="${datasource.url}") String url, @Value(value="${datasource.username}") String username, @Value(value="${datasource.password}") String password) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        return dataSource;
    }

    @Bean
    JdbcSessionDataSourceScriptDatabaseInitializer scriptInitializer(DataSource dataSource) {
        JdbcSessionProperties properties = new JdbcSessionProperties();
        properties.setInitializeSchema(DatabaseInitializationMode.ALWAYS);
        return new JdbcSessionDataSourceScriptDatabaseInitializer(dataSource, properties);
    }
}

